<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('/images/logo/favicon.png')); ?>">

    <title>Statement of Account</title>

    <style  type="text/css">

        @page  {
            margin: 15px 30px 0px 30px;

        }


        hr{ color: #a5a4a4;}
        .darkgray { color: #555353; }
        .gray { color: #757575; }
        .darkblue { color: #1F4583; }

        .header {
            top: 0px;
            left: 0px;
            right: 0px;
        }

        footer {
            /* bottom: -1000px;  */
            left: 0px;
            right: 0px;
            /* height: 250px;  */
        }

        .table-border{
            background-color: #f0f0f0;
            border-radius: 10px;
            border-spacing: 5px;
        }

        .table-td-border{
            background-color: white;
            border-radius: 10px;
            padding: 5px 10px
        }

        body {
            font-family: sans-serif;
            font-size: 12px;
            color: #555353;
        }

        .page-break { page-break-after: always; }

        .center {
            display: flex;
            justify-items: center;
        }
        table, th, td {
            /* border: 1px solid black; */
        }

        .column {
            float: left;
            width: 47%;
            padding-left: 10px;
            padding-right: 0px;
            padding-top: 10px;
            padding-bottom: 10px;
            }

            /* Clear floats after the columns */
            .row:after {
            content: "";
            display: table;
            clear: both;
            }
            .column3 {
            float: left;
            width: 33%;
            font-size: 10px;
            }
            .column4 {
            float: left;
            width: 12%;
            font-size: 10px;
            }
            .column4email {
            float: left;
            width: 35%;
            font-size: 10px;
            }
            .column4namenumber {
            float: left;
            width: 25%;
            font-size: 10px;
            }

    </style>
</head>
<body>
    <?php $__currentLoopData = $soa_generateds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $soa_generated): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="<?php echo e((count($soa_generateds) !== $key+1) ? 'page-break' : ''); ?>">
        <table class="header" width="100%" style="height:auto;">
            <tr>
                <td width="50%" style="vertical-align:top;">
                    <div style="margin-right:5px;">
                        <div style="line-height: 1.4;">
                            <img src="<?php echo e($soa_batch->project_site_logo_url); ?>" alt="No Image" height="80px">
                            <div class="darkgray" style="font-size: 14px; font-weight: bold;"><?php echo e($soa_batch->project_site_registration_name); ?></div>
                            <div class="darkgray"><?php echo e($soa_batch->project_site_address); ?></div>
                            <div class="darkgray">Managed by: Globalland Property Management, Inc.</div>
                        </div>
                        
                        <br>
                        <div style="border: 1px solid #555353; border-radius: 10px; padding: 5px 10px; margin-right:5px; margin-top:5px; height:
auto;">
                            <div class="darkgray" style="font-size: 14px; font-weight: bold; padding-bottom:5px">
                                <?php echo e($soa_generated->customer_name); ?>

                            </div>
                            <table>
                                <tr>
                                    <td valign="top">
                                    <img width="14px"
src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAAAOVBMVEUfVIMfVIMfVIMfVIMfVIMfVIMfVINHcEwfVIMfVIMfVIMfVIMfVIMfVIMfVIMfVIMfVIMfVIMfVINpmbM0AAAAEnRSTlPOge37Bh4NABC0NMeWWXPbZEVMkY0NAAAAeUlEQVQY043QWQ6AIAwE0GEpWATF3v+wsmgkBhPnq3mEEgZ+EnyhW4a4hk6tGLIqV3CTV7aC8Y2xICk9klbkYVMIbG4yHEKysLxnynu3NnLFekyx7NCR6qWObdHBfPT1N4ogESW08UExwPXcgE++cP7NaSHT6v42fwJrVBBrv8j9UAAAAABJRU5ErkJggg=='/>
                                    </td>
                                    <td valign="top">
                                        <?php echo e($soa_generated->lot_inventory_name); ?>

                                    </td>
                                </tr>
                            </table>
                            <br>
                        </div>
                    </div>
                </td>
                <td width="50%" style="vertical-align:top;">
                    <div style="margin-left:5px; line-height: 1.2;">
                        <div style="font-size: 10px; text-align:right;">SOA# <?php echo e($soa_generated->code); ?></div>

                        <div class="darkblue" style="font-size: 20px; text-align:right; padding-bottom: 5px; margin-bottom: 5px"><b>STATEMENT OF
ACCOUNT</b></div>

                        <div style="border: 1px solid #555353; border-radius: 10px; padding: 5px 10px; margin-bottom:5px">
                            <table width="100%">
                                <tr>
                                    <td width="50%"><div style="font-size: 12px;">Billing Period</div></td>
                                    <td width="50%">
                                        <div style="font-size: 12px;">
                                            <?php echo e(date("M-01-Y", strtotime($soa_generated->bill_date)) . ' to  ' .date("M-t-Y",
strtotime($soa_generated->bill_date))); ?>

                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="50%"><div style="font-size: 12px;">Due date</div></td>
                                    <td width="50%"><div style="font-size: 12px;"><?php echo e(date("M-d-Y", strtotime($soa_generated->due_date))); ?></div></td>
                                </tr>
                                <tr>
                                    <td width="50%"><div style="font-size: 12px;">Account Number</div></td>
                                    <td width="50%"><div style="font-size: 12px;"><?php echo e($soa_generated->account_number); ?></div></td>
                                </tr>
                            </table>
                        </div>

                        <div style="border: 1px solid #555353; border-radius: 10px; padding: 5px 10px; margin-bottom:5px">
                            <table width="100%">
                                <tr>
                                    <td width="50%"><div style="font-size: 12px;">Due for the month</div></td>
                                    <td width="50%"><div style="font-size: 12px; font-family: DejaVu Sans; text-align:right"><?php echo e($soa_generated->currency($soa_generated->monthly_due)); ?></div></td>
                                </tr>
                            </table>
                        </div>

                        <div style="border: 1px solid #555353; border-radius: 10px; padding: 5px 10px; margin-bottom:5px">
                            <table width="100%" style="border-collapse: collapse; font-size: 12px;">
                                <tr style="border-bottom: 1px solid #555353;">
                                    <td width="50%" style=""><div style="padding-bottom: 2px">Previous Billing</div></td>
                                    <td width="50%"></td>
                                </tr>
                                <tr >
                                    <td width="50%"><div style="padding-left:12px;">Prev. Bill Amount</div></td>
                                    <td width="50%"><div style="font-family: DejaVu Sans; text-align:right"><?php echo e($soa_generated->currency($soa_generated->previous_amount_due)); ?></div></td>
                                </tr>
                                <tr style="border-bottom: 1px solid #555353">
                                    <td width="50%"><div style="padding-left:12px; padding-bottom: 2px">Payments and Credits</div></td>
                                    <td width="50%"><div style="font-family: DejaVu Sans; text-align:right; padding-bottom: 2px"><?php echo e($soa_generated->currency($soa_generated->last_amount_paid)); ?></div></td>
                                </tr>
                                <tr>
                                    <td width="50%"><div>Remaining Balance</div></td>
                                    <td width="50%"><div style="font-family: DejaVu Sans; text-align:right;"><?php echo e($soa_generated->currency($soa_generated->last_bill_balance)); ?></div></td>
                                </tr>
                            </table>
                        </div>

                        <div style="border: 1px solid #555353; border-radius: 10px; padding: 5px 10px; margin-bottom:5px">
                            <table width="100%">
                                <tr>
                                    <td width="50%"><div style="font-size: 15px;"><b>Amount to Pay</b></div></td>
                                    <td width="50%"><div style="font-size: 15px; font-family: DejaVu Sans; text-align:right"><b><?php echo e($soa_generated->currency($soa_generated->amount_due)); ?></b></div></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
        

        
        <main>
            <div>
                <br>
                <div class="" style="min-height: 570px; border: 1px solid #555353; border-radius: 10px;">

                    
                    
                    <div class="" style="padding: 5px">
                        <table style="background-color: white; border-radius: 10px;
                            padding: 10px 5px" width="100%">
                            <thead>
                                <tr>
                                    <th style="padding-bottom: 10px; text-align: left;" width="20%">Date</th>
                                    <th style="padding-bottom: 10px;text-align: left;" width="20%">Type</th>
                                    <th style="padding-bottom: 10px;text-align: left;" width="">Description</th>
                                    <th style="padding-bottom: 10px;text-align: left;" width="15%">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="font-size: 10px;"></td>
                                    <td style="font-size: 10px;"></td>
                                    <td style="font-size: 10px;">Previous Statement Balance</td>
                                    <td style="font-size: 10px; text-align:right;">
                                        <span class="" style="font-family: DejaVu Sans;">
                                            <?php echo e($soa_generated->currency($soa_generated->previous_amount_due)); ?>

                                        </span>
                                    </td>
                                </tr>
                                <?php $__currentLoopData = $soa_generated->SoaSummaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soa_summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="font-size: 10px;"><?php echo e($soa_summary->date); ?></td>
                                    <td style="font-size: 10px;"><?php echo e($soa_summary->type()); ?></td>
                                    <td style="font-size: 10px;"><?php echo e($soa_summary->description); ?></td>
                                    <td style="font-size: 10px; text-align:right; ">
                                        <span class="" style="font-family: DejaVu Sans;">
                                            <?php echo e($soa_generated->currency($soa_summary->total_amount)); ?>

                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr><td colspan="4"><hr></td></tr>
                                <tr>
                                    <td colspan="2"></td>
                                    <td>TOTAL (AMOUNT TO PAY)</td>
                                    <td colspan="1" style="text-align:right;">
                                        <span class="" style="font-family: DejaVu Sans;">
                                            <?php echo e($soa_generated->currency($soa_generated->totalSummaryAmount())); ?>

                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
        

        
        
        <footer>
            <table  width="100%">
                <thead>
                <tr>
                    <th colspan="3">
                    <div style="min-height: 30px; border: 1px solid #555353; border-radius: 10px;">
                        <div style="padding-left:25px; padding-right:5px; padding-top:10px; padding-bottom:10px; font-weight:normal; font-size:10px; text-align:left;">
                            Please be advised that the actual due amount is based on the latest cut-off date and will be subject to the regular reconciliation of invoices and payments.
Any difference between the amount indicated in this Statement of Account and the reconciled amount will be reflected on the next Statement of Account.
                        </div>
                    </div>
                    <div style="min-height: auto; border: 1px solid #555353; border-radius: 10px; margin-top: 5px;">
                        <div class="row">
                            <div class="column" style="font-weight:normal; font-size:12px; text-align:left;">
                                <div>DOWNLOAD AND REGISTER NOW</div>
                                <div class="darkblue" style="font-weight: bold; padding-bottom: 10px; font-size:14px;">PROPTECH BY GLOBALLAND APP</div>
                                <div class="row" style="text-align: center ;">
                                    <div class="column3">
                                        <p style="margin:0px;">Google Play Store</p>
                                        <img src='<?php echo e(url('images/asset/soa_images/playstore.png')); ?>' alt="" height="120px" width="120px">
                                    </div>
                                    <div class="column3">
                                        <p style="margin:0px;">Huawei App Gallery</p>
                                        <img src='<?php echo e(url('images/asset/soa_images/huwawei.png')); ?>' alt="" height="120px" width="120px">
                                        </div>
                                    <div class="column3">
                                        <p style="margin:0px;">Apple App Store</p>
                                        <img src='<?php echo e(url('images/asset/soa_images/appstore.png')); ?>' alt="" height="120px" width="120px">
                                    </div>
                                </div>
                            </div>
                            <div class="column" style="font-weight:bold; font-size:12px; text-align:left;">
                                        <div style="font-weight:normal; font-size:12px"><br>
                                            FEATURES
                                        </div>
                                        <ul style="list-style-type:none; line-height: 15px; padding:0px;">
                                            <li><img style="vertical-align:middle"
            src='data:image/png;base64,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'
            alt="" heigh="20" width="20">
                                                <span style="font-size:12px; font-weight:normal;">View <b>real</b> time posting of transactions and<b>monthly e-statement</b></span>
                                            </li>
                                            <li>
                                                <img style="vertical-align:middle" src='
            data:image/png;base64,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'
            alt="" heigh="20" width="20">
            <span style="font-size:12px; font-weight:normal;">Save the <b>environment</b> | Subscribe with <b>paperless billing</b></span>

                                            </li>
                                            <li>
                                                <img style="vertical-align:middle"
            src='data:image/png;base64,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'
            alt="" heigh="20" width="20">
                                            <span style="font-size:12px; font-weight:normal;">
                                                Pay <b>online</b> (online fund transfer, e-wallet or QR Payment)</span>
                                                <br><br><span style="font-weight: normal; font-size:12px;">REMINDER</span>
                                            </li>
                                            <li>
                                                <img style="vertical-align:middle" src='
            data:image/png;base64,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'
            alt="" heigh="20" width="20">
            <span style="font-size:12px; font-weight:normal;">For <b>check payments</b>, make it payable to <?php echo e($soa_batch->project_site_registration_name); ?><span>
                                            </li>
                                        </ul>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="min-height: 30px; border: 1px solid #555353; border-radius: 10px; margin-top: 5px; padding-top: 10px">
                        <div class="column4" style="font-weight:bold; font-size:12px; text-align:center; padding-top: 5px">CONTACT US</div>
                        <?php if($soa_batch->projectSite->contact_name ?? false && $soa_batch->projectSite->contact_number ?? false &&
$soa_batch->projectSite->contact_email ?? false): ?>
                        <div class="column4namenumber" style="font-weight:bold; font-size:12px; text-align:center;">
                            <img style="vertical-align:middle"
src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAAAP1BMVEVHcExVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1OJuiyPAAAAFHRSTlMA5C4c+txZsCkOze27moRykps4NMTQSaMAAACcSURBVBjTfVBbEsQgCKtWwVfti/uftYi12p2d5ktDIIFp+sKs9fxmPKCN0SL4zjk0JDDoHi7wN61r4lK4WY+sWbjRL/zAOgFYoETgFLeAkEUYpO5DkUoWS6OSbEmmI40zKeqHbO43Ke0DpF2MSGHOWEZWoxLJbNVoMy0Sh89tudzC85rprK8zhb48qh2OA3bVD1JPx3id7v+Rf3ABfiIJ/UDxBh4AAAAASUVORK5CYII='
alt="" heigh="20" width="20">
                            <span><?php echo e($soa_batch->projectSite->contact_name ?? ""); ?></span>
                        </div>
                        <div class="column4namenumber" style="font-weight:bold; font-size:12px; text-align:center;">
                            <img style="vertical-align:middle"
src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUBAMAAAB/pwA+AAAALVBMVEVHcExVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1Ob6ufzAAAADnRSTlMAnElxilOxyJoYE+dGaA4pYUYAAABHSURBVAjXY2Bg4Ao2NjZdwAAC094BQSaYaVey77X7YzCzL8AsmfUFmCmnwMDA9HBAmGfvQJl9Ae4lUOfYlXi4QB2J5HSYhwBydCarWEeHSAAAAABJRU5ErkJggg=='
alt="" heigh="20" width="20">
                            <span><?php echo e($soa_batch->projectSite->contact_number ?? ""); ?></span>
                        </div>
                        <div class="column4email" style="font-weight:bold; font-size:12px; text-align:left;">
                            <img style="vertical-align:middle"
                            src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAAAOVBMVEVVU1NVU1NVU1NVU1NVU1NVU1NVU1NHcExVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1NVU1Mw4evpAAAAEnRSTlPOge37Bh4NABC0NMeWWXPbZEVMkY0NAAAAeUlEQVQY043QWQ6AIAwE0GEpWATF3v+wsmgkBhPnq3mEEgZ+EnyhW4a4hk6tGLIqV3CTV7aC8Y2xICk9klbkYVMIbG4yHEKysLxnynu3NnLFekyx7NCR6qWObdHBfPT1N4ogESW08UExwPXcgE++cP7NaSHT6v42fwJrVBBrv8j9UAAAAABJRU5ErkJggg=='
                            alt="" heigh="20" width="20">
                            <span><?php echo e($soa_batch->projectSite->contact_email ?? ""); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    </th>
                </tr>
                </thead>
            </table>
        </footer>
        
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\pmg-api-billing\Modules/Soa\Resources/views/soa/statement-of-account.blade.php ENDPATH**/ ?>